﻿' 版权所有 (C) Microsoft Corporation。保留所有权利。
''' <summary>
'''System.Security.Principal.IIdentity 接口的示例实现。此类封装
'''连接到当前线程的用户标识。这只是一个 IPrincipal 和
'''IIdentity 如何关联的示例；该算法是不安全的。
''' </summary>
''' <remarks></remarks>
Public Class SampleIIdentity : Implements System.Security.Principal.IIdentity

    Private nameValue As String
    Private authenticated As Boolean

    ''' <summary>
    '''使用提供的名称和密码创建一个新标识。
    ''' </summary>
    ''' <param name="name">用户名</param>
    ''' <param name="password">身份验证期间使用的用户密码</param>
    ''' <remarks></remarks>
    Public Sub New(ByVal name As String, ByVal password As String)
        nameValue = name
        If password.Equals("password") Then
            authenticated = True
        Else
            authenticated = False
        End If
    End Sub

    ''' <summary>
    '''返回当前的身份验证机制。此处只是将密码与“password”比较，但
    '''更合理的 AuthenticationType 可能是“SqlDatabase”、“LDAP”等。
    ''' </summary>
    ''' <value></value>
    ''' <remarks></remarks>
    Public ReadOnly Property AuthenticationType() As String Implements System.Security.Principal.IIdentity.AuthenticationType
        Get
            Return "An Insecure Sample Authentication Mechanism"
        End Get
    End Property

    ''' <summary>
    '''此用户是否经过身份验证？如果提供的密码与“password”匹配，则返回 true。
    ''' </summary>
    ''' <value></value>
    ''' <remarks></remarks>
    Public ReadOnly Property IsAuthenticated() As Boolean Implements System.Security.Principal.IIdentity.IsAuthenticated
        Get
            Return authenticated
        End Get
    End Property

    ''' <summary>
    '''与此标识关联的用户的名称。
    ''' </summary>
    ''' <value></value>
    ''' <remarks></remarks>
    Public ReadOnly Property Name() As String Implements System.Security.Principal.IIdentity.Name
        Get
            Return nameValue
        End Get
    End Property
End Class

